void copy (int w, int h, unsigned char *bytes, unsigned char *dest)
{
  int i,j;

  for (i = 0; i < w; i++)  
    for (j = 0; j < h; j++)
      {
	dest[j*w + i] = bytes[j*w + i];
      }
}

void light (int w, int h, unsigned char *bytes, unsigned char val)
{
  int i,j;

  for (i = 0; i < w; i++)  
    for (j = 0; j < h; j++)
      {
	unsigned char current = bytes[j*w + i];
	bytes[j*w + i] = (((int)current + val)>255)?255:current+val;
      }
}

void curve (int w, int h, unsigned char *bytes, unsigned char *lut)
{
  int i,j;

  for (i = 0; i < w; i++)  
    for (j = 0; j < h; j++)
      {
	unsigned char current = bytes[j*w + i];
	bytes[j*w + i] = lut[current];
      }
}

void transfo (int w, int h, unsigned char *bytes, unsigned char *dest, unsigned char *lut, unsigned char val)
{
  copy (w, h, bytes, dest);
  curve (w, h, dest, lut);
  light (w, h, dest, val);
}
